//*************************************************************************************
//#Project  :AD18F08
//#Version  :v1.02
//#DATE     :202323
//-------------------------change list-------------------------------------------------
//===============================================================================
//--Version.----------------Content---------------------------------------------Who---
//V1.01						Modify the ADC automatic acquisition				zyf	
//V1.02						Add	OSCTUNE											zyf	
//============================================================
//|-1 -|- initial version                                                                                       

//***********************************************************


#ifndef	__AD18F08_H
#define	__AD18F08_H


#define _XTAL_FREQ 16000000
#pragma intrinsic(_delay)
extern __nonreentrant void _delay(unsigned long);
/*
#pragma intrinsic(_delaywdt)
extern __nonreentrant void _delaywdt(unsigned long);
*/

#define __delay_us(x) _delay((unsigned long)((x)*(_XTAL_FREQ/4000000)))
#define __delay_ms(x) _delay((unsigned long)((x)*(_XTAL_FREQ/4000.0)))
#define SLEEP_PWIDLE()      SMCR = 0X01; SLEEP();NOP();NOP()
#define SLEEP_PWSAVE()      SMCR = 0X03; SLEEP();NOP();NOP()
#define SLEEP_DEEPPWSAVE()  SMCR = 0X05; SLEEP();NOP();NOP()
#define SLEEP_PWOFF()       SMCR = 0X07; SLEEP();NOP();NOP()

/*

__CONFIG(1,_FINTOSC_DIV1_1L     & _DBG_OFF_1L       & _LVREN_OFF_1L    & _LVR24V_1L                                                  );
__CONFIG(2,_FLASH_CP1_OFF_2L    & _FLASH_CP0_OFF_2L & _IDIS_OFF_2L     & _CKSUM_OFF_2L  & _CBP_OFF_2L   & _RESETE_OFF_2L & _RSEL_LOW_2L & _STV_ON_2L  );
__CONFIG(3,_PSUT_2_3L           & _FCPU_4T_3L       & _WDTE_OFF_3L    & _TWDT_000_3L                                                ); 
__CONFIG(4,_OSCM_HIRC_16M_4L    & _MTPDIS_OFF_4L    & _ADCSP_ON_4L                                                                                       );

*/



static volatile unsigned char	TOSU                    @0xfff;
static volatile unsigned char	TOSH                    @0xffe;
static volatile unsigned char	TOSL                    @0xffd;
static volatile unsigned char	PCLATU                  @0xffb;
static volatile unsigned char	PLCATH                  @0xffa;
static volatile unsigned char	PCL                     @0xff9;
static volatile unsigned char	TBLPTRU                 @0xff8;
static volatile unsigned char	TBLPTRH                 @0xff7;
static volatile unsigned char	TBLPTRL                 @0xff6;
static volatile unsigned char	TABLAT                  @0xff5;
static volatile unsigned char	PRODH                   @0xff4;
static volatile unsigned char	PRODL                   @0xff3;
static volatile unsigned char	INTCON                  @0xff2;
static volatile unsigned char	OSCTUNE                 @0xf06;
static volatile unsigned char	OSCT                    @0xf07;
/*Definitions for INTCON register*/
static volatile bit	 GIEH                         @((unsigned)&INTCON*8)+7;
static volatile bit	 GIE                         @((unsigned)&INTCON*8)+7;
static volatile bit	 GIEL                         @((unsigned)&INTCON*8)+6;
static volatile bit	 PEIE                         @((unsigned)&INTCON*8)+6;

/*Definitions for OSCTUNE register*/
static volatile bit	 OSCTUNE6                       @((unsigned)&OSCTUNE*8)+6;
static volatile bit	 OSCTUNE5                       @((unsigned)&OSCTUNE*8)+5;
static volatile bit	 OSCTUNE4                       @((unsigned)&OSCTUNE*8)+4;
static volatile bit	 OSCTUNE3                       @((unsigned)&OSCTUNE*8)+3;
static volatile bit	 OSCTUNE2                       @((unsigned)&OSCTUNE*8)+2;
static volatile bit	 OSCTUNE1                       @((unsigned)&OSCTUNE*8)+1;
static volatile bit	 OSCTUNE0                       @((unsigned)&OSCTUNE*8)+0;
/*Definitions for OSCT register*/
static volatile bit	 OSCTEN                      @((unsigned)&OSCT*8)+7;

static volatile unsigned char	PCON                    @0xff1;
/*Definitions for PCON register*/
static volatile bit	 IPEN                         @((unsigned)&PCON*8)+7;
static volatile bit	 PB0ST                        @((unsigned)&PCON*8)+6;
static volatile bit	 LVDM1                        @((unsigned)&PCON*8)+5;
static volatile bit	 LVDM0                        @((unsigned)&PCON*8)+4;
static volatile bit	 LVD2                         @((unsigned)&PCON*8)+2;
static volatile bit	 LVD1                         @((unsigned)&PCON*8)+1;
static volatile bit	 LVD0                         @((unsigned)&PCON*8)+0;


static volatile unsigned char	INDF                    @0xfef;
static volatile unsigned char	POSTINC0                @0xfee;
static volatile unsigned char	POSTDEC0                @0xfed;
static volatile unsigned char	PREINC0                 @0xfec;
static volatile unsigned char	PLUSW0                  @0xfeb;
static volatile unsigned char	FSR0H                   @0xfea;
static volatile unsigned char	FSR0L                   @0xfe9;
static volatile unsigned char	WREG                    @0xfe8;
static volatile unsigned char	INDF1                   @0xfe7;
static volatile unsigned char	POSTINC1                @0xfe6;
static volatile unsigned char	POSTDEC1                @0xfe5;
static volatile unsigned char	PREINC1                 @0xfe4;
static volatile unsigned char	PLUSW1                  @0xfe3;
static volatile unsigned char	FSR1H                   @0xfe2;
static volatile unsigned char	FSR1L                   @0xfe1;
static volatile unsigned char	BSR                     @0xfe0;
static volatile unsigned char	INDF2                   @0xfdf;
static volatile unsigned char	POSTINC2                @0xfde;
static volatile unsigned char	POSTDEC2                @0xfdd;
static volatile unsigned char	PREINC2                 @0xfdc;
static volatile unsigned char	PLUSW2                  @0xfdb;
static volatile unsigned char	FSR2H                   @0xfda;
static volatile unsigned char	FSR2L                   @0xfd9;
static volatile unsigned char	STATUS                  @0xfd8;
/*Definitions for STATUS register*/
static volatile bit	 N                            @((unsigned)&STATUS*8)+4;
static volatile bit	 OV                           @((unsigned)&STATUS*8)+3;
static volatile bit	 Z                            @((unsigned)&STATUS*8)+2;
static volatile bit	 DC                           @((unsigned)&STATUS*8)+1;
static volatile bit	 C                            @((unsigned)&STATUS*8)+0;


static volatile unsigned char	T0CON                   @0xfd7;
/*Definitions for T0CON register*/
static volatile bit	 T0OUT                        @((unsigned)&T0CON*8)+7;
static volatile bit	 T0CS1                        @((unsigned)&T0CON*8)+6;
static volatile bit	 T0CS0                        @((unsigned)&T0CON*8)+5;
static volatile bit	 T0SE                         @((unsigned)&T0CON*8)+4;
static volatile bit	 PSA                          @((unsigned)&T0CON*8)+3;
static volatile bit	 PS2                          @((unsigned)&T0CON*8)+2;
static volatile bit	 PS1                          @((unsigned)&T0CON*8)+1;
static volatile bit	 PS0                          @((unsigned)&T0CON*8)+0;


static volatile unsigned char	PR0                     @0xfd6;
static volatile unsigned char	TMR0                    @0xfd5;
static volatile unsigned char	PWM0DUTY                @0xfd4;
static volatile unsigned char	PWM0CON                 @0xfd3;
/*Definitions for PWM0CON register*/
static volatile bit	 POLS_03                      @((unsigned)&PWM0CON*8)+7;
static volatile bit	 POLS_02                      @((unsigned)&PWM0CON*8)+6;
static volatile bit	 POLS_01                      @((unsigned)&PWM0CON*8)+5;
static volatile bit	 POLS_00                      @((unsigned)&PWM0CON*8)+4;
static volatile bit	 PWM03EN                      @((unsigned)&PWM0CON*8)+3;
static volatile bit	 PWM02EN                      @((unsigned)&PWM0CON*8)+2;
static volatile bit	 PWM01EN                      @((unsigned)&PWM0CON*8)+1;
static volatile bit	 PWM00EN                      @((unsigned)&PWM0CON*8)+0;


static volatile unsigned char	RCON                    @0xfd2;
/*Definitions for RCON register*/
static volatile bit	 IRFEN                        @((unsigned)&RCON*8)+7;
static volatile bit	 EMCEN                        @((unsigned)&RCON*8)+6;
static volatile bit	 RSTF1                        @((unsigned)&RCON*8)+5;
static volatile bit	 RSTF0                        @((unsigned)&RCON*8)+4;
static volatile bit	 TO                           @((unsigned)&RCON*8)+3;
static volatile bit	 PD                           @((unsigned)&RCON*8)+2;
static volatile bit	 POR                          @((unsigned)&RCON*8)+1;
static volatile bit	 LVR                          @((unsigned)&RCON*8)+0;


static volatile unsigned char	TMR1H                   @0xfd1;
static volatile unsigned char	TMR1L                   @0xfd0;
static volatile unsigned char	T1CON0                  @0xfcf;
/*Definitions for T1CON0 register*/
static volatile bit	 T1CK1                        @((unsigned)&T1CON0*8)+7;
static volatile bit	 T1CK0                        @((unsigned)&T1CON0*8)+6;
static volatile bit	 T1CKPS1                      @((unsigned)&T1CON0*8)+5;
static volatile bit	 T1CKPS0                      @((unsigned)&T1CON0*8)+4;
static volatile bit	 T1SE                         @((unsigned)&T1CON0*8)+3;
static volatile bit	 T1SYNC                       @((unsigned)&T1CON0*8)+2;
static volatile bit	 TMR1CS0                      @((unsigned)&T1CON0*8)+1;
static volatile bit	 TMR1ON                       @((unsigned)&T1CON0*8)+0;


static volatile unsigned char	T1CON1                  @0xfce;
/*Definitions for T1CON1 register*/
static volatile bit	 INT2EDGE                     @((unsigned)&T1CON1*8)+7;
static volatile bit	 INT1EDGE                     @((unsigned)&T1CON1*8)+6;
static volatile bit	 INT0EDGE                     @((unsigned)&T1CON1*8)+5;
static volatile bit	 T1EDGE                       @((unsigned)&T1CON1*8)+4;
static volatile bit	 T1CH1                        @((unsigned)&T1CON1*8)+3;
static volatile bit	 T1CH0                        @((unsigned)&T1CON1*8)+2;
static volatile bit	 T1M1                         @((unsigned)&T1CON1*8)+1;
static volatile bit	 T1M0                         @((unsigned)&T1CON1*8)+0;


static volatile unsigned char	TMR2L                   @0xfcd;
static volatile unsigned char	TMR2H                   @0xfcc;
static volatile unsigned char	PR2L                    @0xfcb;
static volatile unsigned char	PR2H                    @0xfca;
static volatile unsigned char	T2CON                   @0xfc9;
/*Definitions for T2CON register*/
static volatile bit	 PWM2CAEN                     @((unsigned)&T2CON*8)+7;
static volatile bit	 T2OUTPS3                     @((unsigned)&T2CON*8)+6;
static volatile bit	 T2OUTPS2                     @((unsigned)&T2CON*8)+5;
static volatile bit	 T2OUTPS1                     @((unsigned)&T2CON*8)+4;
static volatile bit	 T2OUTPS0                     @((unsigned)&T2CON*8)+3;
static volatile bit	 TMR2ON                       @((unsigned)&T2CON*8)+2;
static volatile bit	 T2CKPS1                      @((unsigned)&T2CON*8)+1;
static volatile bit	 T2CKPS0                      @((unsigned)&T2CON*8)+0;


static volatile unsigned char	CCPR1H                  @0xfc8;
static volatile unsigned char	CCPR1L                  @0xfc7;
static volatile unsigned char	CCPR1LH                 @0xfc6;
/*Definitions for CCPR1LH register*/
static volatile bit	 T2CAPEN                      @((unsigned)&CCPR1LH*8)+7;


static volatile unsigned char	PMS                     @0xfc5;
/*Definitions for PMS register*/
static volatile bit	 DMISTK2                      @((unsigned)&PMS*8)+7;
static volatile bit	 PWMH                         @((unsigned)&PMS*8)+6;
static volatile bit	 PMS21                        @((unsigned)&PMS*8)+5;
static volatile bit	 PMS20                        @((unsigned)&PMS*8)+4;
static volatile bit	 PMS11                        @((unsigned)&PMS*8)+3;
static volatile bit	 PMS10                        @((unsigned)&PMS*8)+2;
static volatile bit	 PMS01                        @((unsigned)&PMS*8)+1;
static volatile bit	 PMS00                        @((unsigned)&PMS*8)+0;


static volatile unsigned char	PXC                     @0xfc4;
/*Definitions for PXC register*/
static volatile bit	 T3PWMEN                      @((unsigned)&PXC*8)+7;
static volatile bit	 T3PWMMODE                    @((unsigned)&PXC*8)+6;
static volatile bit	 PXC21                        @((unsigned)&PXC*8)+5;
static volatile bit	 PXC20                        @((unsigned)&PXC*8)+4;
static volatile bit	 PXC11                        @((unsigned)&PXC*8)+3;
static volatile bit	 PXC10                        @((unsigned)&PXC*8)+2;
static volatile bit	 PXC01                        @((unsigned)&PXC*8)+1;
static volatile bit	 PXC00                        @((unsigned)&PXC*8)+0;


static volatile unsigned char	DTC                     @0xfc3;
/*Definitions for DTC register*/
static volatile bit	 DTCKS1                       @((unsigned)&DTC*8)+7;
static volatile bit	 DTCKS0                       @((unsigned)&DTC*8)+6;
static volatile bit	 DTEN                         @((unsigned)&DTC*8)+5;
static volatile bit	 DTD4                         @((unsigned)&DTC*8)+4;
static volatile bit	 DTD3                         @((unsigned)&DTC*8)+3;
static volatile bit	 DTD2                         @((unsigned)&DTC*8)+2;
static volatile bit	 DTD1                         @((unsigned)&DTC*8)+1;
static volatile bit	 DTD0                         @((unsigned)&DTC*8)+0;


static volatile unsigned char	POLS                    @0xfc2;
/*Definitions for POLS register*/
static volatile bit	 PT2MODE                      @((unsigned)&POLS*8)+6;
static volatile bit	 POLS21                       @((unsigned)&POLS*8)+5;
static volatile bit	 POLS20                       @((unsigned)&POLS*8)+4;
static volatile bit	 POLS11                       @((unsigned)&POLS*8)+3;
static volatile bit	 POLS10                       @((unsigned)&POLS*8)+2;
static volatile bit	 POLS01                       @((unsigned)&POLS*8)+1;
static volatile bit	 POLS00                       @((unsigned)&POLS*8)+0;


static volatile unsigned char	PME                     @0xfc1;
/*Definitions for PME register*/
static volatile bit	 PT1MODE                      @((unsigned)&PME*8)+7;
static volatile bit	 PT0MODE                      @((unsigned)&PME*8)+6;
static volatile bit	 PWM2EN1                      @((unsigned)&PME*8)+5;
static volatile bit	 PWM2EN0                      @((unsigned)&PME*8)+4;
static volatile bit	 PWM1EN1                      @((unsigned)&PME*8)+3;
static volatile bit	 PWM1EN0                      @((unsigned)&PME*8)+2;
static volatile bit	 PWM0EN1                      @((unsigned)&PME*8)+1;
static volatile bit	 PWM0EN0                      @((unsigned)&PME*8)+0;


static volatile unsigned char	PCS                     @0xfc0;
/*Definitions for PCS register*/
static volatile bit	 PWM21CS                      @((unsigned)&PCS*8)+3;
static volatile bit	 PWM20CS                      @((unsigned)&PCS*8)+2;
static volatile bit	 PWM11CS                      @((unsigned)&PCS*8)+1;
static volatile bit	 PWM10CS                      @((unsigned)&PCS*8)+0;


static volatile unsigned char	CCPCON                  @0xfbf;
/*Definitions for CCPCON register*/
static volatile bit	 CCP1CH3                      @((unsigned)&CCPCON*8)+7;
static volatile bit	 CCP1CH2                      @((unsigned)&CCPCON*8)+6;
static volatile bit	 CCP1CH1                      @((unsigned)&CCPCON*8)+5;
static volatile bit	 CCP1CH0                      @((unsigned)&CCPCON*8)+4;
static volatile bit	 CCP1M3                       @((unsigned)&CCPCON*8)+3;
static volatile bit	 CCP1M2                       @((unsigned)&CCPCON*8)+2;
static volatile bit	 CCP1M1                       @((unsigned)&CCPCON*8)+1;
static volatile bit	 CCP1M0                       @((unsigned)&CCPCON*8)+0;


static volatile unsigned char	PWM1CON0                @0xfbe;
/*Definitions for PWM1CON0 register*/
static volatile bit	 TKSEL                        @((unsigned)&PWM1CON0*8)+7;
static volatile bit	 CMPFLT                       @((unsigned)&PWM1CON0*8)+6;
static volatile bit	 ASTART                       @((unsigned)&PWM1CON0*8)+5;
static volatile bit	 ACLOSE                       @((unsigned)&PWM1CON0*8)+4;
static volatile bit	 IOFLT                        @((unsigned)&PWM1CON0*8)+3;
static volatile bit	 PWMADPOS1                    @((unsigned)&PWM1CON0*8)+2;
static volatile bit	 PWMADPOS0                    @((unsigned)&PWM1CON0*8)+1;
static volatile bit	 PWM10ADEN                    @((unsigned)&PWM1CON0*8)+0;


static volatile unsigned char	PWM1CON1                @0xfbd;
static volatile unsigned char	T3CON                   @0xfbc;
/*Definitions for T3CON register*/
static volatile bit	 PWM3CAEN                     @((unsigned)&T3CON*8)+7;
static volatile bit	 T3OUTPS3                     @((unsigned)&T3CON*8)+6;
static volatile bit	 T3OUTPS2                     @((unsigned)&T3CON*8)+5;
static volatile bit	 T3OUTPS1                     @((unsigned)&T3CON*8)+4;
static volatile bit	 T3OUTPS0                     @((unsigned)&T3CON*8)+3;
static volatile bit	 TMR3ON                       @((unsigned)&T3CON*8)+2;
static volatile bit	 T3CKPS1                      @((unsigned)&T3CON*8)+1;
static volatile bit	 T3CKPS0                      @((unsigned)&T3CON*8)+0;


static volatile unsigned char	TMR3H                   @0xfbb;
static volatile unsigned char	TMR3L                   @0xfba;
static volatile unsigned char	PR3H                    @0xfb9;
static volatile unsigned char	PR3L                    @0xfb8;
static volatile unsigned char	PWM5H                   @0xfb7;
static volatile unsigned char	PWM5L                   @0xfb6;
static volatile unsigned char	PWM4H                   @0xfb5;
static volatile unsigned char	PWM4L                   @0xfb4;
static volatile unsigned char	PWM3H                   @0xfb3;
static volatile unsigned char	PWM3L                   @0xfb2;
static volatile unsigned char	PWM2H                   @0xfb1;
static volatile unsigned char	PWM2L                   @0xfb0;


static volatile unsigned char	PWM2CON0                @0xfaf;
/*Definitions for PWM2CON0 register*/
static volatile bit	 PWM5OEN                      @((unsigned)&PWM2CON0*8)+7;
static volatile bit	 PWM4OEN                      @((unsigned)&PWM2CON0*8)+6;
static volatile bit	 PWM3OEN                      @((unsigned)&PWM2CON0*8)+5;
static volatile bit	 PWM2OEN                      @((unsigned)&PWM2CON0*8)+4;
static volatile bit	 PWM5EN                       @((unsigned)&PWM2CON0*8)+3;
static volatile bit	 PWM4EN                       @((unsigned)&PWM2CON0*8)+2;
static volatile bit	 PWM3EN                       @((unsigned)&PWM2CON0*8)+1;
static volatile bit	 PWM2EN                       @((unsigned)&PWM2CON0*8)+0;


static volatile unsigned char	PWM2CON1                @0xfae;
/*Definitions for PWM2CON1 register*/
static volatile bit	 POLS5                        @((unsigned)&PWM2CON1*8)+3;
static volatile bit	 POLS4                        @((unsigned)&PWM2CON1*8)+2;
static volatile bit	 POLS3                        @((unsigned)&PWM2CON1*8)+1;
static volatile bit	 POLS2                        @((unsigned)&PWM2CON1*8)+0;


static volatile unsigned char	PWM2CON3                @0xfad;
/*Definitions for PWM2CON3 register*/
static volatile bit	 P5CS1                        @((unsigned)&PWM2CON3*8)+7;
static volatile bit	 P5CS0                        @((unsigned)&PWM2CON3*8)+6;
static volatile bit	 P4CS1                        @((unsigned)&PWM2CON3*8)+5;
static volatile bit	 P4CS0                        @((unsigned)&PWM2CON3*8)+4;
static volatile bit	 P3CS1                        @((unsigned)&PWM2CON3*8)+3;
static volatile bit	 P3CS0                        @((unsigned)&PWM2CON3*8)+2;
static volatile bit	 P2CS1                        @((unsigned)&PWM2CON3*8)+1;
static volatile bit	 P2CS0                        @((unsigned)&PWM2CON3*8)+0;

static volatile unsigned char	ADCMP0H                 @0xfab;
static volatile unsigned char	ADCMP1H                 @0xfaa;
static volatile unsigned char	ADCMP01L                @0xfa9;
static volatile unsigned char	ADRESH                  @0xfa8;
static volatile unsigned char	ADRESL                  @0xfa7;


static volatile unsigned char	ADCON0                  @0xfa6;
/*Definitions for ADCON0 register*/
static volatile bit	 ADFM                         @((unsigned)&ADCON0*8)+7;
static volatile bit	 ADCMPMODE                    @((unsigned)&ADCON0*8)+6;
static volatile bit	 CHS3                         @((unsigned)&ADCON0*8)+5;
static volatile bit	 CHS2                         @((unsigned)&ADCON0*8)+4;
static volatile bit	 CHS1                         @((unsigned)&ADCON0*8)+3;
static volatile bit	 CHS0                         @((unsigned)&ADCON0*8)+2;
static volatile bit	 GO                           @((unsigned)&ADCON0*8)+1;
static volatile bit	 DONE                         @((unsigned)&ADCON0*8)+1;
static volatile bit	 ADON                         @((unsigned)&ADCON0*8)+0;


static volatile unsigned char	ADCON1                  @0xfa5;
/*Definitions for ADCON1 register*/
static volatile bit	 ADVREF1                      @((unsigned)&ADCON1*8)+7;
static volatile bit	 ADVREF0                      @((unsigned)&ADCON1*8)+6;
static volatile bit	 ACQT2                        @((unsigned)&ADCON1*8)+5;
static volatile bit	 ACQT1                        @((unsigned)&ADCON1*8)+4;
static volatile bit	 ACQT0                        @((unsigned)&ADCON1*8)+3;
static volatile bit	 ADCS2                        @((unsigned)&ADCON1*8)+2;
static volatile bit	 ADCS1                        @((unsigned)&ADCON1*8)+1;
static volatile bit	 ADCS0                        @((unsigned)&ADCON1*8)+0;

static volatile unsigned char	IPR1                    @0xfa3;
/*Definitions for IPR1 register*/
static volatile bit	 ADCMP1IP                     @((unsigned)&IPR1*8)+7;
static volatile bit	 ADCMP0IP                     @((unsigned)&IPR1*8)+6;
static volatile bit	 ADIP                         @((unsigned)&IPR1*8)+5;
static volatile bit	 CCPIP                        @((unsigned)&IPR1*8)+4;
static volatile bit	 TMR3IP                       @((unsigned)&IPR1*8)+3;
static volatile bit	 TMR2IP                       @((unsigned)&IPR1*8)+2;
static volatile bit	 TMR1IP                       @((unsigned)&IPR1*8)+1;
static volatile bit	 TMR0IP                       @((unsigned)&IPR1*8)+0;


static volatile unsigned char	PIR1                    @0xfa2;
/*Definitions for PIR1 register*/
static volatile bit	 ADCMP1IF                     @((unsigned)&PIR1*8)+7;
static volatile bit	 ADCMP0IF                     @((unsigned)&PIR1*8)+6;
static volatile bit	 ADIF                         @((unsigned)&PIR1*8)+5;
static volatile bit	 CCPIF                        @((unsigned)&PIR1*8)+4;
static volatile bit	 TMR3IF                       @((unsigned)&PIR1*8)+3;
static volatile bit	 TMR2IF                       @((unsigned)&PIR1*8)+2;
static volatile bit	 TMR1IF                       @((unsigned)&PIR1*8)+1;
static volatile bit	 TMR0IF                       @((unsigned)&PIR1*8)+0;


static volatile unsigned char	PIE1                    @0xfa1;
/*Definitions for PIE1 register*/
static volatile bit	 ADCMP1IE                     @((unsigned)&PIE1*8)+7;
static volatile bit	 ADCMP0IE                     @((unsigned)&PIE1*8)+6;
static volatile bit	 ADIE                         @((unsigned)&PIE1*8)+5;
static volatile bit	 CCPIE                        @((unsigned)&PIE1*8)+4;
static volatile bit	 TMR3IE                       @((unsigned)&PIE1*8)+3;
static volatile bit	 TMR2IE                       @((unsigned)&PIE1*8)+2;
static volatile bit	 TMR1IE                       @((unsigned)&PIE1*8)+1;
static volatile bit	 TMR0IE                       @((unsigned)&PIE1*8)+0;


static volatile unsigned char	IPR2                    @0xfa0;
/*Definitions for IPR2 register*/
static volatile bit	 PBIP                         @((unsigned)&IPR2*8)+6;
static volatile bit	 PAIP                         @((unsigned)&IPR2*8)+5;
static volatile bit	 INT2IP                       @((unsigned)&IPR2*8)+4;
static volatile bit	 INT1IP                       @((unsigned)&IPR2*8)+3;
static volatile bit	 INT0IP                       @((unsigned)&IPR2*8)+2;
static volatile bit	 LVDIP                        @((unsigned)&IPR2*8)+1;
static volatile bit	 CMPIP                        @((unsigned)&IPR2*8)+0;


static volatile unsigned char	PIR2                    @0xf9f;
/*Definitions for PIR2 register*/
static volatile bit	 PBIF                         @((unsigned)&PIR2*8)+6;
static volatile bit	 PAIF                         @((unsigned)&PIR2*8)+5;
static volatile bit	 INT2IF                       @((unsigned)&PIR2*8)+4;
static volatile bit	 INT1IF                       @((unsigned)&PIR2*8)+3;
static volatile bit	 INT0IF                       @((unsigned)&PIR2*8)+2;
static volatile bit	 LVDIF                        @((unsigned)&PIR2*8)+1;
static volatile bit	 CMPIF                        @((unsigned)&PIR2*8)+0;


static volatile unsigned char	PIE2                    @0xf9e;
/*Definitions for PIE2 register*/
static volatile bit	 PBIE                         @((unsigned)&PIE2*8)+6;
static volatile bit	 PAIE                         @((unsigned)&PIE2*8)+5;
static volatile bit	 INT2IE                       @((unsigned)&PIE2*8)+4;
static volatile bit	 INT1IE                       @((unsigned)&PIE2*8)+3;
static volatile bit	 INT0IE                       @((unsigned)&PIE2*8)+2;
static volatile bit	 LVDIE                        @((unsigned)&PIE2*8)+1;
static volatile bit	 CMPIE                        @((unsigned)&PIE2*8)+0;

static volatile unsigned char	SMTB                    @0xf99;
/*Definitions for SMTB register*/
static volatile bit	 SMTB7                        @((unsigned)&SMTB*8)+7;
static volatile bit	 SMTB6                        @((unsigned)&SMTB*8)+6;
static volatile bit	 SMTB5                        @((unsigned)&SMTB*8)+5;
static volatile bit	 SMTB4                        @((unsigned)&SMTB*8)+4;
static volatile bit	 SMTB3                        @((unsigned)&SMTB*8)+3;
static volatile bit	 SMTB2                        @((unsigned)&SMTB*8)+2;
static volatile bit	 SMTB1                        @((unsigned)&SMTB*8)+1;
static volatile bit	 SMTB0                        @((unsigned)&SMTB*8)+0;


static volatile unsigned char	SMTA                    @0xf98;
/*Definitions for SMTA register*/
static volatile bit	 SMTA5                        @((unsigned)&SMTA*8)+5;
static volatile bit	 SMTA4                        @((unsigned)&SMTA*8)+4;
static volatile bit	 SMTA3                        @((unsigned)&SMTA*8)+3;
static volatile bit	 SMTA2                        @((unsigned)&SMTA*8)+2;
static volatile bit	 SMTA1                        @((unsigned)&SMTA*8)+1;
static volatile bit	 SMTA0                        @((unsigned)&SMTA*8)+0;

static volatile unsigned char	PBOD                    @0xf95;
/*Definitions for PBOD register*/
static volatile bit	 PB7OD                        @((unsigned)&PBOD*8)+7;
static volatile bit	 PB6OD                        @((unsigned)&PBOD*8)+6;
static volatile bit	 PB5OD                        @((unsigned)&PBOD*8)+5;
static volatile bit	 PB4OD                        @((unsigned)&PBOD*8)+4;
static volatile bit	 PB3OD                        @((unsigned)&PBOD*8)+3;
static volatile bit	 PB2OD                        @((unsigned)&PBOD*8)+2;
static volatile bit	 PB1OD                        @((unsigned)&PBOD*8)+1;
static volatile bit	 PB0OD                        @((unsigned)&PBOD*8)+0;


static volatile unsigned char	PAOD                    @0xf94;
/*Definitions for PAOD register*/
static volatile bit	 PA5OD                        @((unsigned)&PAOD*8)+5;
static volatile bit	 PA4OD                        @((unsigned)&PAOD*8)+4;
static volatile bit	 PA3OD                        @((unsigned)&PAOD*8)+3;
static volatile bit	 PA2OD                        @((unsigned)&PAOD*8)+2;
static volatile bit	 PA1OD                        @((unsigned)&PAOD*8)+1;
static volatile bit	 PA0OD                        @((unsigned)&PAOD*8)+0;

static volatile unsigned char	TRISB                   @0xf91;
/*Definitions for TRISB register*/
static volatile bit	 TRISB7                       @((unsigned)&TRISB*8)+7;
static volatile bit	 TRISB6                       @((unsigned)&TRISB*8)+6;
static volatile bit	 TRISB5                       @((unsigned)&TRISB*8)+5;
static volatile bit	 TRISB4                       @((unsigned)&TRISB*8)+4;
static volatile bit	 TRISB3                       @((unsigned)&TRISB*8)+3;
static volatile bit	 TRISB2                       @((unsigned)&TRISB*8)+2;
static volatile bit	 TRISB1                       @((unsigned)&TRISB*8)+1;
static volatile bit	 TRISB0                       @((unsigned)&TRISB*8)+0;

static volatile unsigned char	TRISA                   @0xf90;
/*Definitions for TRISA register*/
static volatile bit	 TRISA5                       @((unsigned)&TRISA*8)+5;
static volatile bit	 TRISA4                       @((unsigned)&TRISA*8)+4;
static volatile bit	 TRISA3                       @((unsigned)&TRISA*8)+3;
static volatile bit	 TRISA2                       @((unsigned)&TRISA*8)+2;
static volatile bit	 TRISA1                       @((unsigned)&TRISA*8)+1;
static volatile bit	 TRISA0                       @((unsigned)&TRISA*8)+0;


static volatile unsigned char	PBPD                    @0xf8d;
/*Definitions for PBPD register*/
static volatile bit	 PB7PD                        @((unsigned)&PBPD*8)+7;
static volatile bit	 PB6PD                        @((unsigned)&PBPD*8)+6;
static volatile bit	 PB5PD                        @((unsigned)&PBPD*8)+5;
static volatile bit	 PB4PD                        @((unsigned)&PBPD*8)+4;
static volatile bit	 PB3PD                        @((unsigned)&PBPD*8)+3;
static volatile bit	 PB2PD                        @((unsigned)&PBPD*8)+2;
static volatile bit	 PB1PD                        @((unsigned)&PBPD*8)+1;
static volatile bit	 PB0PD                        @((unsigned)&PBPD*8)+0;


static volatile unsigned char	PAPD                    @0xf8c;
/*Definitions for PAPD register*/
static volatile bit	 PA5PD                        @((unsigned)&PAPD*8)+5;
static volatile bit	 PA4PD                        @((unsigned)&PAPD*8)+4;
static volatile bit	 PA3PD                        @((unsigned)&PAPD*8)+3;
static volatile bit	 PA2PD                        @((unsigned)&PAPD*8)+2;
static volatile bit	 PA1PD                        @((unsigned)&PAPD*8)+1;
static volatile bit	 PA0PD                        @((unsigned)&PAPD*8)+0;

static volatile unsigned char	PINB                    @0xf89;
static volatile unsigned char	PINA                    @0xf88;
static volatile unsigned char	PBPU                    @0xf85;

/* Definitions for PINB register */
static volatile  bit	PINB7		                              @ ((unsigned)&PINB*8)+7;
static volatile  bit	PINB6		                              @ ((unsigned)&PINB*8)+6;
static volatile  bit	PINB5		                              @ ((unsigned)&PINB*8)+5;
static volatile  bit	PINB4		                              @ ((unsigned)&PINB*8)+4;
static volatile  bit	PINB3		                              @ ((unsigned)&PINB*8)+3;
static volatile  bit	PINB2		                              @ ((unsigned)&PINB*8)+2;
static volatile  bit	PINB1		                              @ ((unsigned)&PINB*8)+1;
static volatile  bit	PINB0		                              @ ((unsigned)&PINB*8)+0;
/* Definitions for PINA register */
static volatile  bit	PINA5		                              @ ((unsigned)&PINA*8)+5;
static volatile  bit	PINA4		                              @ ((unsigned)&PINA*8)+4;
static volatile  bit	PINA3		                              @ ((unsigned)&PINA*8)+3;
static volatile  bit	PINA2		                              @ ((unsigned)&PINA*8)+2;
static volatile  bit	PINA1		                              @ ((unsigned)&PINA*8)+1;
static volatile  bit	PINA0		                              @ ((unsigned)&PINA*8)+0;

/*Definitions for PBPU register*/
static volatile bit	 PB7PU                        @((unsigned)&PBPU*8)+7;
static volatile bit	 PB6PU                        @((unsigned)&PBPU*8)+6;
static volatile bit	 PB5PU                        @((unsigned)&PBPU*8)+5;
static volatile bit	 PB4PU                        @((unsigned)&PBPU*8)+4;
static volatile bit	 PB3PU                        @((unsigned)&PBPU*8)+3;
static volatile bit	 PB2PU                        @((unsigned)&PBPU*8)+2;
static volatile bit	 PB1PU                        @((unsigned)&PBPU*8)+1;
static volatile bit	 PB0PU                        @((unsigned)&PBPU*8)+0;


static volatile unsigned char	PAPU                    @0xf84;
/*Definitions for PAPU register*/
static volatile bit	 PA5PU                        @((unsigned)&PAPU*8)+5;
static volatile bit	 PA4PU                        @((unsigned)&PAPU*8)+4;
static volatile bit	 PA3PU                        @((unsigned)&PAPU*8)+3;
static volatile bit	 PA2PU                        @((unsigned)&PAPU*8)+2;
static volatile bit	 PA1PU                        @((unsigned)&PAPU*8)+1;
static volatile bit	 PA0PU                        @((unsigned)&PAPU*8)+0;

static volatile unsigned char	PORTB                   @0xf81;
/*Definitions for PORTB register*/
static volatile bit	 PB7                          @((unsigned)&PORTB*8)+7;
static volatile bit	 PB6                          @((unsigned)&PORTB*8)+6;
static volatile bit	 PB5                          @((unsigned)&PORTB*8)+5;
static volatile bit	 PB4                          @((unsigned)&PORTB*8)+4;
static volatile bit	 PB3                          @((unsigned)&PORTB*8)+3;
static volatile bit	 PB2                          @((unsigned)&PORTB*8)+2;
static volatile bit	 PB1                          @((unsigned)&PORTB*8)+1;
static volatile bit	 PB0                          @((unsigned)&PORTB*8)+0;

static volatile unsigned char	PORTA                   @0xf80;
/*Definitions for PORTA register*/
static volatile bit	 PA5                          @((unsigned)&PORTA*8)+5;
static volatile bit	 PA4                          @((unsigned)&PORTA*8)+4;
static volatile bit	 PA3                          @((unsigned)&PORTA*8)+3;
static volatile bit	 PA2                          @((unsigned)&PORTA*8)+2;
static volatile bit	 PA1                          @((unsigned)&PORTA*8)+1;
static volatile bit	 PA0                          @((unsigned)&PORTA*8)+0;



static volatile unsigned char	CMPCON0                 @0xf78;
/*Definitions for CMPCON0 register*/
static volatile bit	 CMPEN                        @((unsigned)&CMPCON0*8)+7;
static volatile bit	 CMPPOS                       @((unsigned)&CMPCON0*8)+6;
static volatile bit	 CMPPCH2                      @((unsigned)&CMPCON0*8)+5;
static volatile bit	 CMPPCH1                      @((unsigned)&CMPCON0*8)+4;
static volatile bit	 CMPPCH0                      @((unsigned)&CMPCON0*8)+3;
static volatile bit	 CMPNCH2                      @((unsigned)&CMPCON0*8)+2;
static volatile bit	 CMPNCH1                      @((unsigned)&CMPCON0*8)+1;
static volatile bit	 CMPNCH0                      @((unsigned)&CMPCON0*8)+0;


static volatile unsigned char	CMPCON1                 @0xf77;
/*Definitions for CMPCON1 register*/
static volatile bit	 CMPHYSN_VOL1                 @((unsigned)&CMPCON1*8)+7;
static volatile bit	 CMPHYSN_VOL0                 @((unsigned)&CMPCON1*8)+6;
static volatile bit	 CMPHYSP_VOL1                 @((unsigned)&CMPCON1*8)+5;
static volatile bit	 CMPHYSP_VOL0                 @((unsigned)&CMPCON1*8)+4;
static volatile bit	 CMPOUT                       @((unsigned)&CMPCON1*8)+0;


static volatile unsigned char	CMPCON2                 @0xf76;
/*Definitions for CMPCON2 register*/
static volatile bit	 CMPFILTER3                   @((unsigned)&CMPCON2*8)+7;
static volatile bit	 CMPFILTER2                   @((unsigned)&CMPCON2*8)+6;
static volatile bit	 CMPFILTER1                   @((unsigned)&CMPCON2*8)+5;
static volatile bit	 CMPFILTER0                   @((unsigned)&CMPCON2*8)+4;
static volatile bit	 C0OUT3EN                     @((unsigned)&CMPCON2*8)+3;
static volatile bit	 C0OUT2EN                     @((unsigned)&CMPCON2*8)+2;
static volatile bit	 C0OUT1EN                     @((unsigned)&CMPCON2*8)+1;
static volatile bit	 C0OUT0EN                     @((unsigned)&CMPCON2*8)+0;

static volatile unsigned char	DACCON                  @0xf74;
/*Definitions for DACCON register*/
static volatile bit	 DAC_SEL                      @((unsigned)&DACCON*8)+7;
static volatile bit	 DACEN                        @((unsigned)&DACCON*8)+6;
static volatile bit	 DACS5                        @((unsigned)&DACCON*8)+5;
static volatile bit	 DACS4                        @((unsigned)&DACCON*8)+4;
static volatile bit	 DAC3                         @((unsigned)&DACCON*8)+3;
static volatile bit	 DAC2                         @((unsigned)&DACCON*8)+2;
static volatile bit	 DAC1                         @((unsigned)&DACCON*8)+1;
static volatile bit	 DAC0                         @((unsigned)&DACCON*8)+0;


static volatile unsigned char	nan                     @0xf73;


static volatile unsigned char	FVRCON0                 @0xf72;
/*Definitions for FVRCON0 register*/
static volatile bit	 FVR_A2D_OUT                  @((unsigned)&FVRCON0*8)+7;
static volatile bit	 FVROUTEN                     @((unsigned)&FVRCON0*8)+6;
static volatile bit	 FVREN                        @((unsigned)&FVRCON0*8)+5;
static volatile bit	 FVRPGA1                      @((unsigned)&FVRCON0*8)+4;
static volatile bit	 FVRPGA0                      @((unsigned)&FVRCON0*8)+3;
static volatile bit	 FVR_SEL2                     @((unsigned)&FVRCON0*8)+2;
static volatile bit	 FVR_SEL1                     @((unsigned)&FVRCON0*8)+1;
static volatile bit	 FVR_SEL0                     @((unsigned)&FVRCON0*8)+0;


static volatile unsigned char	FVRCON1                 @0xf71;
/*Definitions for FVRCON1 register*/
static volatile bit	 FVR_OFFSET_EN                @((unsigned)&FVRCON1*8)+5;


static volatile unsigned char	LCDCON0                 @0xf70;
/*Definitions for LCDCON0 register*/
static volatile bit	 LCDEN                        @((unsigned)&LCDCON0*8)+7;
static volatile bit	 LCDCSEL1                     @((unsigned)&LCDCON0*8)+1;
static volatile bit	 LCDCSEL0                     @((unsigned)&LCDCON0*8)+0;


static volatile unsigned char	LCDCON1                 @0xf6f;
/*Definitions for LCDCON1 register*/
static volatile bit	 COM7EN                       @((unsigned)&LCDCON1*8)+7;
static volatile bit	 COM6EN                       @((unsigned)&LCDCON1*8)+6;
static volatile bit	 COM5EN                       @((unsigned)&LCDCON1*8)+5;
static volatile bit	 COM4EN                       @((unsigned)&LCDCON1*8)+4;
static volatile bit	 COM3EN                       @((unsigned)&LCDCON1*8)+3;
static volatile bit	 COM2EN                       @((unsigned)&LCDCON1*8)+2;
static volatile bit	 COM1EN                       @((unsigned)&LCDCON1*8)+1;
static volatile bit	 COM0EN                       @((unsigned)&LCDCON1*8)+0;


static volatile unsigned char	LCDCON2                 @0xf6e;
/*Definitions for LCDCON2 register*/
static volatile bit	 COM13EN                      @((unsigned)&LCDCON2*8)+5;
static volatile bit	 COM12EN                      @((unsigned)&LCDCON2*8)+4;
static volatile bit	 COM11EN                      @((unsigned)&LCDCON2*8)+3;
static volatile bit	 COM10EN                      @((unsigned)&LCDCON2*8)+2;
static volatile bit	 COM9EN                       @((unsigned)&LCDCON2*8)+1;
static volatile bit	 COM8EN                       @((unsigned)&LCDCON2*8)+0;

static volatile unsigned char	IAPTRIG                 @0xf6c;

static volatile unsigned char	IAPCTRL                 @0xf6b;
/*Definitions for IAPCTRL register*/
static volatile bit	 ERR                          @((unsigned)&IAPCTRL*8)+3;
static volatile bit	 LOCK                         @((unsigned)&IAPCTRL*8)+2;
static volatile bit	 ER                           @((unsigned)&IAPCTRL*8)+1;
static volatile bit	 PG                           @((unsigned)&IAPCTRL*8)+0;


static volatile unsigned char	IAPADDRH                @0xf6a;
static volatile unsigned char	IAPADDRL                @0xf69;
static volatile unsigned char	IAPDATH                 @0xf68;
static volatile unsigned char	IAPDATL                 @0xf67;
static volatile unsigned char	IAPWAIT                 @0xf66;


static volatile unsigned char	SMCR                    @0xf65;
/*Definitions for SMCR register*/
static volatile bit	 SM2                          @((unsigned)&SMCR*8)+3;
static volatile bit	 SM1                          @((unsigned)&SMCR*8)+2;
static volatile bit	 SM0                          @((unsigned)&SMCR*8)+1;
static volatile bit	 SE                           @((unsigned)&SMCR*8)+0;


static volatile unsigned char	OSCCON                  @0xf64;
/*Definitions for OSCCON register*/
static volatile bit	 PLL                          @((unsigned)&OSCCON*8)+7;
static volatile bit	 FINTOSC2                     @((unsigned)&OSCCON*8)+6;
static volatile bit	 FINTOSC1                     @((unsigned)&OSCCON*8)+5;
static volatile bit	 FINTOSC0                     @((unsigned)&OSCCON*8)+4;
static volatile bit	 CKOE1                        @((unsigned)&OSCCON*8)+3;
static volatile bit	 CKOE0                        @((unsigned)&OSCCON*8)+2;
static volatile bit	 OSCF                         @((unsigned)&OSCCON*8)+1;
static volatile bit	 OSCM                         @((unsigned)&OSCCON*8)+0;


static volatile unsigned char	SIGCON                  @0xf63;
/*Definitions for SIGCON register*/
static volatile bit	 ICE_TMEREN                   @((unsigned)&SIGCON*8)+7;
static volatile bit	 SIGS                         @((unsigned)&SIGCON*8)+0;


static volatile unsigned char	CLKCFG1                 @0xf62;
/*Definitions for CLKCFG1 register*/
static volatile bit	 CMPCLKEN                     @((unsigned)&CLKCFG1*8)+7;
static volatile bit	 DACCLKEN                     @((unsigned)&CLKCFG1*8)+6;
static volatile bit	 ADCCLKEN                     @((unsigned)&CLKCFG1*8)+5;
static volatile bit	 CCPCLKEN                     @((unsigned)&CLKCFG1*8)+4;
static volatile bit	 T3CLKEN                      @((unsigned)&CLKCFG1*8)+3;
static volatile bit	 T2CLKEN                      @((unsigned)&CLKCFG1*8)+2;
static volatile bit	 T1CLKEN                      @((unsigned)&CLKCFG1*8)+1;
static volatile bit	 T0CLKEN                      @((unsigned)&CLKCFG1*8)+0;

static volatile unsigned char	PAINTMASK               @0xf60;
/*Definitions for PAINTMASK register*/
static volatile bit	 PAINTMASK5                   @((unsigned)&PAINTMASK*8)+5;
static volatile bit	 PAINTMASK4                   @((unsigned)&PAINTMASK*8)+4;
static volatile bit	 PAINTMASK3                   @((unsigned)&PAINTMASK*8)+3;
static volatile bit	 PAINTMASK2                   @((unsigned)&PAINTMASK*8)+2;
static volatile bit	 PAINTMASK1                   @((unsigned)&PAINTMASK*8)+1;
static volatile bit	 PAINTMASK0                   @((unsigned)&PAINTMASK*8)+0;


static volatile unsigned char	PBINTMASK               @0xf5f;
/*Definitions for PBINTMASK register*/
static volatile bit	 PBINTMASK7                   @((unsigned)&PBINTMASK*8)+7;
static volatile bit	 PBINTMASK6                   @((unsigned)&PBINTMASK*8)+6;
static volatile bit	 PBINTMASK5                   @((unsigned)&PBINTMASK*8)+5;
static volatile bit	 PBINTMASK4                   @((unsigned)&PBINTMASK*8)+4;
static volatile bit	 PBINTMASK3                   @((unsigned)&PBINTMASK*8)+3;
static volatile bit	 PBINTMASK2                   @((unsigned)&PBINTMASK*8)+2;
static volatile bit	 PBINTMASK1                   @((unsigned)&PBINTMASK*8)+1;
static volatile bit	 PBINTMASK0                   @((unsigned)&PBINTMASK*8)+0;


static volatile unsigned char	WDTCON                  @0xf58;
/*Definitions for WDTCON register*/
static volatile bit	 PREDIV2                      @((unsigned)&WDTCON*8)+3;
static volatile bit	 PREDIV1                      @((unsigned)&WDTCON*8)+2;
static volatile bit	 PREDIV0                      @((unsigned)&WDTCON*8)+1;
static volatile bit	 WDTEN                        @((unsigned)&WDTCON*8)+0;

static volatile unsigned char	CURCON                  @0xf55;
/*Definitions for CURCON register*/
static volatile bit	 PBCUR                        @((unsigned)&CURCON*8)+3;
static volatile bit	 PACUR                        @((unsigned)&CURCON*8)+2;
static volatile bit	 PA2CUR                       @((unsigned)&CURCON*8)+1;
static volatile bit	 PA1CUR                       @((unsigned)&CURCON*8)+0;


static volatile unsigned char	ANASEL0                 @0xf54;
/*Definitions for ANASEL0 register*/
static volatile bit	 PA5AEN                       @((unsigned)&ANASEL0*8)+5;
static volatile bit	 PA4AEN                       @((unsigned)&ANASEL0*8)+4;
static volatile bit	 PA3AEN                       @((unsigned)&ANASEL0*8)+3;
static volatile bit	 PA2AEN                       @((unsigned)&ANASEL0*8)+2;
static volatile bit	 PA1AEN                       @((unsigned)&ANASEL0*8)+1;
static volatile bit	 PA0AEN                       @((unsigned)&ANASEL0*8)+0;


static volatile unsigned char	ANASEL1                 @0xf53;
/*Definitions for ANASEL1 register*/
static volatile bit	 PB7AEN                       @((unsigned)&ANASEL1*8)+7;
static volatile bit	 PB6AEN                       @((unsigned)&ANASEL1*8)+6;
static volatile bit	 PB5AEN                       @((unsigned)&ANASEL1*8)+5;
static volatile bit	 PB4AEN                       @((unsigned)&ANASEL1*8)+4;
static volatile bit	 PB3AEN                       @((unsigned)&ANASEL1*8)+3;
static volatile bit	 PB2AEN                       @((unsigned)&ANASEL1*8)+2;
static volatile bit	 PB1AEN                       @((unsigned)&ANASEL1*8)+1;
static volatile bit	 PB0AEN                       @((unsigned)&ANASEL1*8)+0;



/* Macros to access bytes within words and words within longs */
#define LOW_BYTE(x)     ((unsigned char)((x)&0xFF))
#define HIGH_BYTE(x)    ((unsigned char)(((x)>>8)&0xFF))
#define LOW_WORD(x)     ((unsigned short)((x)&0xFFFF))
#define HIGH_WORD(x)    ((unsigned short)(((x)>>16)&0xFFFF))

/* C access to assembler insructions */	
#define	CLRWDT()	    asm(" clrwdt")
#define	NOP()		    asm(" nop")
//#define	RESET()		    asm(" reset")
#define SLEEP()		    asm(" sleep")

#define	___mkstr1(x)	#x
#define	___mkstr(x)	___mkstr1(x)

/* Store a word value to a particular configuration word register eg.
 * __CONFIG(4, DEBUGEN & LVPDIS); // write to config word 4
 * config mask attributes (such as DEBUGEN) defined in chip-specific
 * header file. */
#define	__CONFIG(n, x)	asm("\tpsect config,class=CONFIG");\
			asm("global config_word" ___mkstr(n)); \
			asm("\torg ("___mkstr(n)"-1)*2"); \
			asm("config_word" ___mkstr(n)":"); \
			asm("\tdw "___mkstr(x))
			

#define __IDLOC(w)      asm("\tpsect idloc,class=IDLOC");\
			asm("\tglobal\tidloc_word"); \
			asm("idloc_word:"); \
			asm("\tirpc\t__arg," ___mkstr(w)); \
			asm("\tdb 0f&__arg&h"); \
			asm("\tendm")



/* Address definitions for config word registers
 * (NOT TO BE USED WITH __CONFIG MACRO!) */
#define CONFIG1L	0x300000
#define CONFIG1H	0x300001
#define CONFIG2L	0x300002
#define CONFIG2H	0x300003
#define CONFIG3L	0x300004
#define CONFIG3H	0x300005
#define CONFIG4L	0x300006
#define CONFIG4H	0x300007
#define CONFIG5L	0x300008
#define CONFIG5H	0x300009
#define CONFIG6L	0x30000A
#define CONFIG6H	0x30000B
#define CONFIG7L	0x30000C
#define CONFIG7H	0x30000D

//;----- CONFIG0 Options --------------------------------------------------------
#define   _LVR24V_1L                 0xFFF8     // LVR-out Reset set to 2.4V 
#define   _LVR27V_1L                 0xFFF9     // LVR-out Reset set to 2.7V 
#define   _LVR30V_1L                 0xFFFA     // LVR-out Reset set to 3.0V 
#define   _LVR33V_1L                 0xFFFB     // LVR-out Reset set to 3.3V 
#define   _LVR36V_1L                 0xFFFC     // LVR-out Reset set to 3.6V 
#define   _LVR38V_1L                 0xFFFD     // LVR-out Reset set to 3.8V 
#define   _LVR42V_1L                 0xFFFE     // LVR-out Reset set to 4.2V 
#define   _LVR43V_1L                 0xFFFF     // LVR-out Reset set to 4.3V                        

#define   _LVREN_ON_1L               0xFFFF     //  Enable LVR reset
#define   _LVREN_OFF_1L              0xFFF7     //  Disable LVR reset 	
	
	
#define  _DBG_ON_1L                  0xFFFF		// DEBUG mode  ENABLE 
#define  _DBG_OFF_1L                 0xFFEF		// DEBUG mode  DISABLE 		
	
	
#define   _FINTOSC_DIV1_1L           0xFFFF     // Fosc DIVIDER 1:1  
#define   _FINTOSC_DIV2_1L           0xFFDF     // Fosc DIVIDER 1:2  
#define   _FINTOSC_DIV4_1L           0xFFBF     // Fosc DIVIDER 1:4  
#define   _FINTOSC_DIV8_1L           0xFF9F     // Fosc DIVIDER 1:8  
#define   _FINTOSC_DIV16_1L          0xFF5F     // Fosc DIVIDER 1:16 

//;----- CONFIG1 Options --------------------------------------------------------
#define   _STV_OFF_2L              0xFFFE		//	Stack overflow reset disable
#define   _STV_ON_2L               0xFFFF		//  Stack overflow reset enable

#define  _RSEL_HIGH_2L             0xFFFD		//   pullup 100K,pulldown 300K
#define  _RSEL_LOW_2L              0xFFFF		//   pullup  30K, pulldown 30K

#define  _RESETE_ON_2L             0xFFFF		//  Reset Pin enable
#define  _RESETE_OFF_2L            0xFFFB		//  Reset Pin disable

#define  _CBP_ON_2L                0xFFFF		//  Program code encrypte enable
#define  _CBP_OFF_2L               0xFFF7		//  Program code encrypte disable

#define  _CKSUM_OFF_2L             0xFFEF		// 	cksum  disable
#define  _CKSUM_ON_2L              0xFFFF		//  cksum  enable

#define  _IDIS_OFF_2L              0xFFDF		//	 Read  data is always 0 
#define  _IDIS_ON_2L               0xFFFF		//   Normal read data  

#define  _FLASH_CP0_ON_2L          0xFFFF		//   flash space 0-1k protect enbale 
#define  _FLASH_CP0_OFF_2L         0xFFBF		//   flash space 0-1k protect disbale 

#define  _FLASH_CP1_ON_2L          0xFFFF		//   flash space 1k-2k protect enbale 
#define  _FLASH_CP1_OFF_2L         0xFF7F		//   flash space 1k-2k protect disbale  

//;-------CONFIG2 Options --------------------------------------------------------
#define  _TWDT_111_3L              0xFFFF		// WDT overflow time 8.32s
#define  _TWDT_110_3L              0xFFFE		// WDT overflow time 4.224s
#define  _TWDT_101_3L              0xFFFD		// WDT overflow time 2.176s
#define  _TWDT_100_3L              0xFFFC		// WDT overflow time 1.152s
#define  _TWDT_011_3L              0xFFFB		// WDT overflow time 640ms
#define  _TWDT_010_3L              0xFFFA		// WDT overflow time 384ms
#define  _TWDT_001_3L              0xFFF9		// WDT overflow time 256ms
#define  _TWDT_000_3L              0xFFF8		// WDT overflow time 128ms

#define  _WDTE_OFF_3L             0xFFF7		//   WDT disabled
#define  _WDTE_ON_3L              0xFFFF		//   WDT enabled

#define  _FCPU_4T_3L               0xFFFF		//   4 Instruction cycle
#define  _FCPU_2T_3L               0xFFEF		//   2 Instruction cycle

#define  _PSUT_8_3L                0xFF7F		//  Power on delay  25.8ms
#define  _PSUT_4_3L                0xFF5F		//  Power on delay  288.55ms
#define  _PSUT_2_3L                0xFF3F		//  Power on delay  864.55ms
#define  _PSUT_1_3L                0xFF1F		//  Power on delay  8.05ms  

//;-----  CONFIG3 Options --------------------------------------------------------
#define  _ADCSP_OFF_4L              0xFF82   // ADC low speed 
#define  _ADCSP_ON_4L               0xFF83    // ADC high speed 

#define  _MTPDIS_OFF_4L             0xFF81    // MTPDIS=0
#define  _MTPDIS_ON_4L              0xFF83    // MTPDIS=1
 
#define  _OSCM_HIRC_16M_4L      	0xFF83   //  HIRC(16MHZ) AS MAIN CLOCK  
#define  _OSCM_LIRC_2K_4L          	0xFF03    //LIRC(2KHZ) AS MAIN CLOCK 


#endif
